# C.O.R.E. v0.6 verified
# Atlantic Fleet Carrier Group Fixed by Dr Rare 2008 
# 26th Yankee NG Division Boston Militia Fixed by BM 2009
# Bestmajors Planes Stack Tweak added

country = { 
	tag = USA
	ai = "core_USA_39.ai"
	alignment = { x = 100 y = 0 }
	manpower = 50 # reduced from 3840 because of new events
	headofstate = { type = 9 id = 6001 }
	headofgovernment = { type = 9 id = 6035 }
 	foreignminister = { type = 9 id = 6002 }
 	armamentminister = { type = 9 id = 6003 }
 	ministerofsecurity = { type = 9 id = 6034 }
 	chiefofstaff = { type = 9 id = 6042 }
 	chiefofarmy = { type = 9 id = 6044 }
	chiefofnavy = { type = 9 id = 6077  }     
 	chiefofair = { type = 9 id = 6046 }
	capital = 178
	warentry = 40.000 
	transports = 400
	escorts = 50
	dissent = 2 # The Great Depression

	# Resource Reserves
	coal	=	20000  steel	=	20000	rubber =	20000	oil =	20000	supplies =	5000
	
	diplomats = 15
	diplomacy = {
        relation = { tag = PHI access = yes }
        relation = { tag = LIB access = yes }

			}

	techlevels = {  1000 1100 1200 1300 1400
			2000 2100 2200 2300
			3000 3100 3200 3300 3400
			4000 4100 4200 4300 4400 4500 4600 4700  
			5000 5100 5200 5300 5400 
			6000 6100 6200 6300 6400 6500 6600 6940
			7000 7100 7200 7300 
			8000 8100 8200 8300 
			9000 9100 9200 9300 9400
			10000 10100 10200 
			11000 11100 11200 
			12000 12100 12200 12300
			13000 13100 13200 13300 
			14000 14100 14200 14300 
	}

	techapps = {
		1001 1002 1003 1004 1103 1201 1202 1203 1204 1205 1206 1207 1208 1209 1211 1301 1302 1303 1304 1305 1401 1407 1409 1601 1947 1974 1975 1976 
		2001 2002 2003 2004 2005 2006 2101 2102 2103 2104 2201 2202 2203 2204 2252 2943 2985 2986  
		3001 3002 3003 3004 3005 3006 3007 3101 3102 3103 3104 3201 3202 3203 3204 3205 3206 3207 3301 3302 3401 3402 3404 3406 3012
		4001 4101 4102 4103 4104 4201 4202 4203 4204 4401 4402 4301 4302 4303 4403 4501 4502 4503 4601 
		5006 5007 5008 5009 5010 5011 5012 5013 5014 5015
		5104 5105 5106 5107 5108 5109 5110 5111 5112
		5205 5206 5207 5208 5209 5210 5211 5212 5216 5217 5219
		5305 5306 5307 5308 5309 5310 5311
		6013 6014 6015 6016 6017 6018 6019 6020 6021 6022 6023 6024 6025 6026 6027 6028 6029 6030
		6031 6032 6033 6034 6035 6036 6037 6038 6039 6040 6041
		6113 6114 6115 6116 6117 6118 6119 6120 6121 6122 6123
		6207 6208 6209 6210 6211 6212 6213
		6307 6308 6309 6310 6311 6312
		6411 6412 6413 6414 6415 6416
		6514 6515 6516 6517 6518 6519 6520 6521 6522 6523 6524 6529 6530 6531 6532 6533 6534
		6610 6611 6612 6613 6614 6615 6618 6535 6536 6743 6744
		6716 6719 6720 6915 6722 6725 6726 6727 6728 6730 6734
		6933 6934 6936 6741 6947
		13007 13008 13009 13010 13012 13013 13015
		13105 13106 13107 13108 13109 13111 13113
		13209 13210 13212 13214 13217
		7001 7002 7003 7101 7102 7103 7201 7202 7203 7301 7302
		9001 9002 9004 9005 9003 9006 9007 9008 9009 9010 9011 9101 9102 9103 9104 9105 9106 9107 9108 9109 9301 9302 9303 9305 
		9401 9402 9403 9404 9405 9406 9407 9408 9506 9509 
		10001 10002 10003 10004 10006 10101 10102 10103 10104 10105 10107  
		11001 11002 11003 11004 11101 11102 11103   
		12001 12002 12004 12005 12201 12202 
		14001 14003 14004 14007 14008 14012 14050 14051 14052 14053 14054 14055 14056 14057 14101 14104 14106 14107 14150 14151 14152 
		14154 14155 14156 14158 14201 14204 14250 14251 14252 14253 14254 14255 14256 14257 14258 14263 14264 14995 14973
	 }

### R&D Setup 
# use type = 29504
### R&D Section End


    convoy = { 		  
        id = { type = 14712 id = 5434 } 
        transports = 30 
        escorts = 5 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 158 95 85 15 24 22 } 
        } 

	convoy = { 
        id = { type = 14712 id = 5435 } 
        transports = 30 
        escorts = 5 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 211 214 234 231 230 258 288 } 
        } 

    convoy = { 
        id = { type = 14712 id = 5436 } 
        transports = 15 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 212 227 266 265 2165 267 } 
        } 
	
    ownedprovinces =      {
		177 178 150 129 125 124 122 182 181 183 216 212 217 211 210 184 189 121 188
		187 116 135 117 112 192 193 114 113 105 106 97 104 90 191 195 194 208 196 
		209 204 203 87 86 91 89 94 92 8 155 156 158
		#usa-carribean
		288 267 
		#usa-pacific
		22 28 34 9 6 5 2 1880 1863 45 1889 17 1883 1942 
		}
    controlledprovinces = {
		177 178 150 129 125 124 122 182 181 183 216 212 217 211 210 184 189 121 188
		187 116 135 117 112 192 193 114 113 105 106 97 104 90 191 195 194 208 196 
		209 204 203 87 86 91 89 94 92 8 155 156 158
		#usa-carribean
		288 267 
		#usa-pacific
		22 28 34 9 6 5 2 1880 1863 45 1889 17 1883 1942 
	  }
    nationalprovinces =   {
		177 178 150 129 125 124 122 182 181 183 216 212 217 211 210 184 189 121 188
		187 116 135 117 112 192 193 114 113 105 106 97 104 90 191 195 194 208 196 
		209 204 203 87 86 91 89 94 92 8 155 156 158
		#usa-carribean
		288 267 
		# Hawaii
		22
		#usa-pacific
		9 6 5
		#28 34 2 1880 1863 45 1889 17 1883 1942 
	  }

#############################################
# USA Regular Army OOB - Mainland Deployments
#############################################

# The US Army prior to WW2 was quite small for a power the size of the USA.  These calculations left
# out the National Guard (see below).  In the autumn of the 1939, the US Army had 5 full strength
# infantry divisions (1, 2, 3, Hawaiian, and Philippine) and one cavalry division.  Two more divisions 
# were organizing (the 5th and 6th).  All of the numbered infantry divisions were in the new 
# "triangular" formation of three infantry regiments each.  The Hawaiian and Philippine Divisions 
# retained the old "square" formation from WW1 which entailed two brigades of two infantry regiments 
# each.  There were no brigade or division sized armored formations in the US Army in 1939.  The 
# Hawaiian Division would split in 1941 to form the 24th and 25th Infantry Divisions.  This OOB also 
# includes scratch formations which represent various units charged with the defense of Puerto Rico 
# and the Canal Zone.    

landunit = {
 id = { type = 12331 id = 1 }
 name = "1st Infantry Division"
 location = 125
          
  division = {
   id = { type = 12331 id = 2 }
   type = infantry
   name = "1st Big Red One Division"
   extra = artillery
             }
 division = {				# National Guard
   id = { type = 12331 id = 22 }
   type = militia
   name = "26th Yankee NG Division"
             }
   }

landunit = {
 id = { type = 12331 id = 3 }
 name = "2nd Infantry Division"
 location = 9
 
  division = {
   id = { type = 12331 id = 4 }
   name = "2nd Indianhead Division"
   type = infantry
   extra = artillery 
             }
	}

landunit = {
 id = { type = 12331 id = 5 }
 name = "3rd Infantry Division"
 location = 106

  division = {
   id = { type = 12331 id = 6 }
   name = "3rd Rock of the Marne Division"
   type = infantry
   extra = artillery
             } 
	}

landunit = {
 id = { type = 12331 id = 7 }
 name = "5th Infantry Division"
 location = 217 # Organized at Fort Benning (?)

  division = {
   id = { type = 12331 id = 8 }
   type = infantry
   strength = 5
   name = "5th Red Devils Division"
   extra = artillery
             }
	}

landunit = {
 id = { type = 12331 id = 9 }
 name = "6th Infantry Division"
 location = 106
 
  division = {
   id = { type = 12331 id = 10 }
   type = infantry
   strength = 5
   name = "6th Sightseeing Sixth Division"
   extra = artillery
             }
	}

landunit = {
 id = { type = 12331 id = 11 }
 name = "1st Cavalry Division"
 location = 9

  division = {
   id = { type = 12331 id = 12 }
   type = cavalry
   strength = 100
   name = "1st Cavalry The 1st Team Div."
             }
	}

##################################################
# US Army OOB - Overseas Deployments
##################################################

landunit = { 
 id = { type = 12331 id = 13 }
 name = "Hawaiian Division"
 location = 22

  division = { 
   id = { type = 12331 id = 14 }
   type = infantry
   name = "Hawaiian Division"
   extra = artillery
             }
      }

landunit = {
 id = { type = 12331 id = 15 }
 location = 1802
 name = "Philippine Division"
           
  division = {
   id = { type = 12331 id = 16 } 
   strength = 100
   name = "Philippine Division"
   type = infantry
   extra = artillery
             }
         }

landunit = {
 id = { type = 12331 id = 17 }
 name = "Canal Zone Garrison"
 location = 288
 
  division = {
  id = { type = 12331 id = 18 }
  name = "Panama Mobile Force"
  type = infantry # This force included three infantry regiments and numerous supporting troops 
  extra = artillery
		}
	}

landunit = {
 id = { type = 12331 id = 19 }
 name = "Puerto Rico Garrison"
 location = 267
 
  division = {
  id = { type = 12331 id = 20 }
  name = "192nd Infantry Brigade"
  type = militia
  		}
	}

###########################################
# National Guard Formations
###########################################

# National Guard formations were under the command of the governors of the various states.  They 
# were subsidized by the Federal Government and were supposed to be armed and equipped to US Army
# standards.  The troops had a cadre of full time officers and non-coms, but most billets were 
# filled by part time troops who drilled two days a month with a two to three week summer deployment.
# Most operational deployments in the 1930s were disaster relief at the behest of local government.
# Historically, all of these units were called to federal service in 1940 or 1941.  In game terms they  
# were disbanded between 1940 and 1941 and then, for the most part, re-organized as regular infantry 
# units or fed into the new armored formations of the US Army.  It's worth noting that the switch from 
# militia to regular infantry took a year of full-time training, albeit under peacetime conditions. 
# Prior to their nationalization all of the infantry units retained the "square" WW1 divisional 
# structure of two brigades with two regiments in each brigade.
#
# In addition, apologies in advance to Guard veterans and their families.  The divisional organizations 
# were often drawn from multiple states and no offence is intended by assigning many of these divisions 
# exclusively to one state or another.



landunit = {
 id = { type 12331 id = 23 }
 name = "Virginia & Maryland National Guards"
 location = 178

  division = {
   id = { type = 12331 id = 24 }
   type = militia
   name = "29th Blue and Gray NG Division"
             }
	}

landunit = {
 id = {type = 12331 id = 25}
 name = "New Jersey National Guard"
 location = 177

  division = { 
   id = { type = 12331 id = 26 }
   type = militia
   name = "44th Infantry NG Division"
             }

  division = { 
   id = { type = 12331 id = 27 }
   type = cavalry
   name = "21st Cavalry NG Division"
             }
      }

landunit = {
 id = { type = 12331 id = 28 }
 name = "New York National Guard"
 location = 124

  division = {
   id = { type = 12331 id = 29 }
   type = militia
   name = "27th New York Division NG"
             }
	}

landunit = {
 id = { type = 12331 id = 30 }
 name = "Illinois National Guard"
 location = 187

  division = {
   id = { type = 12331 id = 31 }
   type = militia 
   name = "33rd Golden Cross NG Division"
             }
	}

landunit = {
 id = { type = 12331 id = 32 }
 name = "Missouri & Nebraska National Guards"
 location = 193

  division = {
   id = { type = 12331 id = 33 }
   type = militia
   name = "35th Santa Fe NG Division"
             }
          }

landunit = {
 id = { type = 12331 id = 34 }
 name = "Pennsylvania National Guard"
 location = 122

  division = {
   id = { type = 12331 id = 35 }
   type = militia
   name = "28th Keystone NG Division"
             }
          }

landunit = {
 id = { type = 12331 id = 36 }
 name = "Tennesse & Carolina's National Guards"
 location = 216

  division = {
   id = { type = 12331 id = 37 }
   type = militia
   name = "30th Old Hickory NG Division"
             }
          }

landunit = {
 id = { type = 12331 id = 38 }
 location = 212
 name = "National Guards of the Deep South"
 
  division = {
   id = { type = 12331 id = 39 }
   type = militia
   name = "31st Dixie NG Division"
             }
	}

landunit = {
 id = { type = 12331 id = 40 }
 location = 150
 name = "National Guards of Upper New England"
 
  division = {
   id = { type = 12331 id = 41 }
   type = militia
   name = "43rd Winged Victory NG Division"
            }
	}

landunit = {
 id = { type = 12331 id = 42 }
 location = 116
 name = "Michigan National Guard"
  
  division = {
   id = { type = 12331 id = 43 }
   type = militia 
   name = "32nd Red Arrow NG Division"
             }
	}

landunit = {
 id = { type = 12331 id = 44 }
 location = 192
 name = "Iowa National Guard"

  division = {
   id = { type = 12331 id = 45 }
   type = militia
   name = "34th Red Bull NG Division"
             }
	}

landunit = {
 id = { type = 12331 id = 46 }
 location = 121
 name = "Ohio National Guard"

  division = {
   id = { type = 12331 id = 47 }
   strength = 100
   name = "37th Buckeye NG Division"
   type = militia
             }

  division = {
   id = { type = 12331 id = 48 }
   name = "22nd Cavalry NG Division"
   type = cavalry
             }
	}

landunit = {
 id = { type = 12331 id = 49 }
 location = 188
 name = "Indiana National Guard"

  division = {
   id = { type = 12331 id = 50 }
   name = "38th Cyclone NG Division"
   type = militia
             }
         }

landunit = {
 id = { type = 12331 id = 51 }
 location = 203
 name = "Texas National Guard"

  division = {
   id = { type = 12331 id = 52 } 
   name = "36th Texas NG Division"
   type = Militia
             }

  division = {
   id = { type = 12331 id = 53 } 
   name = "56th Cavalry NG Brigade"
   type = cavalry
   strength = 50
             }
	}

landunit = {
 id = { type = 12331 id = 54 }
 location = 86
 name = "Colorado National Guard"

  division = {
   id = { type = 12331 id = 55 }
   name = "45th Thunderbird NG Division"
   type = militia
             }
         }

landunit = {
 id = { type = 12331 id = 56 }
 location = 158
 name = "California National Guard"

  division = {
   id = { type = 12331 id = 57 }
   name = "40th Sunshine NG Division"
   type = militia
          }
      }

landunit = {
 id = { type = 12331 id = 58 }
 location = 97
 name = "Oregon & Washington National Guards"
 
  division = {
   id = { type = 12331 id = 59 }
   name = "41st Sunset NG Division"
   type = militia
             }
          }

landunit = {
 id = { type = 12331 id = 60 }
 location = 183
 name = "Various National Guards"
 
  division = {
   id = { type = 12331 id = 61 }
   name = "42nd Rainbow NG Division"
   type = militia
             }
          }

landunit = {
 id = { type = 12331 id = 62 }
 location = 112
 name = "Minnesota & Dakota National Guards"
 
  division = {
   id = { type = 12331 id = 63 }
   name = "47th Viking NG Division"
   type = militia
             }
          }

landunit = {
 id = { type = 12331 id = 64 }
 location = 204
 name = "Louisiana & Arkansas National Guards"
 
  division = {
   id = { type = 12331 id = 65 }
   name = "39th Bayou NG Division"
   type = militia
             }
          }

landunit = {
 id = { type = 12331 id = 66 }
 location = 195
 name = "Kansas National Guard"
 
  division = {
   id = { type = 12331 id = 67 }
   name = "23rd Cavalry NG Division"
   type = cavalry
             }
          }

landunit = {
 id = { type = 12331 id = 68 }
 location = 87
 name = "New Mexico National Guard"
 
  division = {
   id = { type = 12331 id = 69 }
   name = "24th Cavalry NG Division"
   type = cavalry
             }
          }

##################################
# USMC Formations
###################################

# The United States possessed (and still possesses) an independent naval infantry force, the US
# Marine Corps.  During the interwar period, this formation organized and trained around the 
# amphibious assault as it primary mission.  While much of the equipment and final tactics still 
# were incomplete as of 1939, this organization had the clearest grasp of the problems of the amphibious 
# assault, including naval gunfire coordination, aerial close support, over the beach logistics, etc.
# with respect to putting it all together in terms of a coherent, effective doctrine.

landunit = {
 id = { type = 12331 id = 70 }
 location = 181
 name = "1st Marine Brigade"
           
  division = {
   id = { type = 12331 id = 71 } 
   strength = 50
   name = "1st Marine The Old Breed Division"
   type = marine
   extra = artillery
           }
         }

landunit = {
 id = { type = 12331 id = 72 }
 location = 92
 name = "2nd Marine Brigade"
           
  division = {
   id = { type = 12331 id = 73 } 
   strength = 50
   name = "2nd Marine Follow Me Division"
   type = marine
   extra = artillery
           }
         }

#############################
# USAAF OOB
#############################

# During the Second World War, there was no independent US Air Force.  Rather, the US Army, US Navy, 
# and US Marine Corps each had their own aviation assets under their own command.  

airunit = {
 id = { type = 12332 id = 1 }
 name = "1st Air Force/I"
 location = 124 

  division = {
   id = { type = 12332 id = 2 }
   name = "2nd Bombardment Wing"
   strength = 50
   type = tactical_bomber
   model = 1
             }
}

airunit = {
 id = { type = 12332 id = 103 }
 name = "1st Air Force/II"
 location = 124 
  division = {
   id = { type = 12332 id = 3 }
   name = "6th Fighter Wing"
   strength = 50
   type = fighter
   model = 2
             }
         }

airunit = {
 id = { type = 12332 id = 4 }
 name = "2nd Air Force/I"
 location = 178 

  division = {
   id = { type = 12332 id = 5 }
   name = "4th Bombardment Wing"
   strength = 50
   type = tactical_bomber
   model = 0
             }
}

airunit = {
 id = { type = 12332 id = 102 }
 name = "2nd Air Force/II"
 location = 178 
  division = {
   id = { type = 12332 id = 6 }
   name = "7th Fighter Wing"
   strength = 50
   type = fighter
   model = 1
             }
         }

airunit = {
 id = { type = 12332 id = 7 }
 name = "3rd Air Force/I"
 location = 106

  division = {
   id = { type = 12332 id = 8 }
   name = "1st Bombardment Wing"
   strength = 30
   type = strategic_bomber
   model = 1
             }
}

airunit = {
 id = { type = 12332 id = 101 }
 name = "3rd Air Force/II"
 location = 106
  division = {
   id = { type = 12332 id = 9 }
   name = "9th Fighter Wing"
   strength = 50
   type = fighter
   model = 0
             }
         }

airunit = {
 id = { type = 12332 id = 10 }
 name = "4th Air Force/I"
 location = 92

  division = {
   id = { type = 12332 id = 11 }
   name = "4th Bombardment Wing"
   strength = 50
   type = dive_bomber
   model = 1
             }
 }

airunit = {
 id = { type = 12332 id = 100 }
 name = "4th Air Force/II"
 location = 92
  division = {
   id = { type = 12332 id = 12 }
   name = "10th Fighter Wing"
   strength = 50
   type = fighter
   model = 0
             }
         }

airunit = {
 id = { type = 12332 id = 13 }
 name = "5th Air Force/I"
 location = 9

  division = {
   id = { type = 12332 id = 14 }
   name = "13th Bombardment Wing"
   strength = 50
   type = dive_bomber
   model = 1
             }
}

airunit = {
 id = { type = 12332 id = 104 }
 name = "5th Air Force/II"
 location = 9
  division = {
   id = { type = 12332 id = 15 }
   name = "12th Bombardment Wing"
   strength = 50
   type = tactical_bomber
   model = 0
             }
	}

airunit = {
 id = { type = 12332 id = 16 }
 name = "Hawaiian Air Force"
 location = 22

  division = {
   id = { type = 12332 id = 17 }
   name = "11th Fighter Wing"
   strength = 50
   type = fighter
   model = 0
             }
         }

airunit = {
 id = { type = 12332 id = 18 }
 name = "Far East Air Force"
 location = 1800

  division = {
   id = { type = 12332 id = 19 }
   name = "62d USAF Fighter Wing"
   strength = 100
   type = fighter
   model = 0
             }
         }

##############################
# USMC Aviation Units
##############################

airunit = {
 id = { type = 12332 id = 20 }
 name = "1st Marine Aircraft Wing"
 location = 181

  division = {
   id = { type = 12332 id = 21 }
   name = "1st Marine Aircraft Wing"
   strength = 50
   type = torpedo_plane
   model = 0
             }
         }

airunit = {
 id = { type = 12332 id = 22 }
 name = "2nd Marine Aircraft Wing"
 location = 92

  division = {
   id = { type = 12332 id = 23 }
   name = "2nd Marine Aircraft Wing"
   strength = 50
   type = torpedo_plane
   model = 0
             }
         }

airunit = {
 id = { type = 12332 id = 24 }
 name = "3rd Marine Aircraft Wing"
 location = 22

  division = {
   id = { type = 12332 id = 25 }
   name = "3rd Marine Aircraft Wing"
   strength = 50
   type = torpedo_plane
   model = 0
             }
         }

##############################
# US Navy Aviation Units
##############################

airunit = {
 id = { type = 12332 id = 26 }
 name = "Patrol Wing 1"
 location = 181

  division = {
   id = { type = 12332 id = 27 }
   name = "Patrol Wing 1"
   strength = 50
   type = naval_bomber
   model = 1
             }
         }

airunit = {
 id = { type = 12332 id = 28 }
 name = "Patrol Wing 2"
 location = 92

  division = {
   id = { type = 12332 id = 29 }
   name = "Patrol Wing 2"
   strength = 50
   type = naval_bomber
   model = 1
             }
         }

#airunit = {
# id = { type = 12332 id = 30 }
# name = "USS Ranger Air Group"
# location = 181
#
#  division = {
#   id = { type = 12332 id = 31 }
#   name = "Carrier Air Wing 7"
#   strength = 100
#   type = torpedo_plane
#   model = 0
#             }
#
#division = {
#   id = { type = 12332 id = 32 }
#   name = "Carrier Air Wing 8"
#   strength = 100
#   type = torpedo_plane
#   model = 0
#             }
#	}



###############################################
# United States 1939 Naval OOB
# CORE 0.83
# by MateDow, Engineer, & Semi-Lobster
###############################################

navalunit = {
	id = { type = 12333 id = 1 }
	name = "Pacific Fleet"
	location = 92 #Los Angeles
	leader = 60385 #Kimmel

	division = {
		id = { type = 12333 id = 2 }
		name = "USS Colorado"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 3 }
		name = "USS Maryland"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 4 }
		name = "USS West Virginia"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 5 }
		name = "USS Tennessee"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 6 }
		name = "USS California"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 7 }
		name = "USS Salt Lake City"
		type = cruiser
		model = 8
		seaattack = 9
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 8 }
		name = "USS Chicago"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 9 }
		name = "USS New Orleans"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 10 }
		name = "USS Brooklyn"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 11 }
		name = "1st Destroyer Flotilla"
		type = destroyer
		model = 8
		}

	division = {
		id = { type = 12333 id = 12 }
		name = "4th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 13 }
		name = "5th Destroyer Flotilla"
		type = destroyer
		model = 6
		}
}

navalunit = {
	id = { type = 12333 id = 14 }
	name = "Pacific Fleet Scouting Group"
	location = 92 #Los Angeles
	leader = 60399 #Mitscher

	division = {
		id = { type = 12333 id = 15 }
		name = "USS Pennsylvania"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 16 }
		name = "USS Arizona"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 17 }
		name = "USS Nevada"
		type = battleship
		model = 6
		seaattack = 15
		}

	division = {
		id = { type = 12333 id = 18 }
		name = "USS Oklahoma"
		type = battleship
		model = 6
		seaattack = 15
		}

	division = {
		id = { type = 12333 id = 19 }
		name = "USS Saratoga"
		type = carrier
		model = 6
		maxspeed = 33
		}

	airunit = {
		id = { type = 12333 id = 1900 }
		name = "Saratoga Air Group"
		leader = 60462

		division = {
			id = { type = 12333 id = 1901 }
			name = "Saratoga Air Group I"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 1902 }
			name = "Saratoga Air Group II"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 1903 }
			name = "Saratoga Air Group III"
			type = torpedo_plane
			model = 0
			}
		}

	division = {
		id = { type = 12333 id = 20 }
		name = "USS Portland"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 21 }
		name = "USS San Francisco"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 22 }
		name = "USS Pensacola"
		type = cruiser
		model = 8
		seaattack = 9
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 23 }
		name = "USS Philadelphia"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 24 }
		name = "6th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 25 }
		name = "7th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 26 }
		name = "8th Destroyer Flotilla"
		type = destroyer
		model = 6
		}
}

navalunit = {
	id = { type = 12333 id = 27 }
	name = "Pacific Fleet Carrier Group"
	location = 92 #Los Angeles
	leader = 60375 #Halsey

	division = {
		id = { type = 12333 id = 28 }
		name = "USS Lexington"
		type = carrier
		model = 6
		maxspeed = 33
		}

	airunit = {
		id = { type = 12333 id = 2800 }
		name = "Lexington Air Group"
		leader = 60476

		division = {
			id = { type = 12333 id = 2801 }
			name = "Lexington Air Group I"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 2802 }
			name = "Lexington Air Group II"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 2803 }
			name = "Lexington Air Group III"
			type = torpedo_plane
			model = 0
			}
		}

	division = {
		id = { type = 12333 id = 29 }
		name = "USS Enterprise"
		type = carrier
		model = 8
		}

	airunit = {
		id = { type = 12333 id = 2900 }
		name = "Enterprise Air Group"
		
		division = {
			id = { type = 12333 id = 2901 }
			name = "Enterprise Air Group I"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 2902 }
			name = "Enterprise Air Group II"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 2903 }
			name = "Enterprise Air Group III"
			type = torpedo_plane
			model = 0
			}
		}

	division = {
		id = { type = 12333 id = 30 }
		name = "USS Louisville"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 31 }
		name = "USS Astoria"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 32 }
		name = "USS Savannah"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 33 }
		name = "USS Nashville"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 34 }
		name = "3rd Destroyer Flotilla"
		type = destroyer
		model = 8
		}

	division = {
		id = { type = 12333 id = 35 }
		name = "10th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 36 }
		name = "20th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 37 }
		name = "23rd Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 38 }
		name = "24th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 39 }
		name = "26th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 40 }
	name = "Atlantic Fleet"
	location = 181 #Norfolk
	leader = 60384 #Kalbfus

	division = {
		id = { type = 12333 id = 41 }
		name = "USS New Mexico"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 42 }
		name = "USS Idaho"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 43 }
		name = "USS Mississippi"
		type = battleship
		model = 6
		}

	division = {
		id = { type = 12333 id = 44 }
		name = "USS Augusta"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 45 }
		name = "USS Indianapolis"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 46 }
		name = "USS Tuscaloosa"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 47 }
		name = "USS Milwaukee"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 48 }
		name = "USS Detroit"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 49 }
		name = "2nd Destroyer Flotilla"
		type = destroyer
		model = 8
		}

	division = {
		id = { type = 12333 id = 50 }
		name = "9th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 51 }
		name = "11th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 52 }
		name = "12th Destroyer Flotilla"
		type = destroyer
		model = 6
		}
}

navalunit = {
	id = { type = 12333 id = 53 }
	name = "Atlantic Fleet Scouting Group"
	location = 181 #Norfolk
	leader = 60387 #Kinkaid

	division = {
		id = { type = 12333 id = 54 }
		name = "USS Arkansas"
		type = battleship
		model = 3
		seaattack = 15
		}

	division = {
		id = { type = 12333 id = 55 }
		name = "USS New York"
		type = battleship
		model = 6
		seaattack = 15
		}

	division = {
		id = { type = 12333 id = 56 }
		name = "USS Texas"
		type = battleship
		model = 6
		seaattack = 15
		}

	division = {
		id = { type = 12333 id = 57 }
		name = "USS Northampton"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 58 }
		name = "USS Chester"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 59 }
		name = "USS Phoenix"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 60 }
		name = "USS Cincinnati"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 61 }
		name = "USS Omaha"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 62 }
		name = "13th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 63 }
		name = "14th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 64 }
		name = "15th Destroyer Flotilla"
		type = destroyer
		model = 6
		}

	division = {
		id = { type = 12333 id = 65 }
		name = "18th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 66 }
	name = "Asiatic Fleet"
	location = 1804 #Manila
	leader = 60378 #Hart

	division = {
		id = { type = 12333 id = 67 }
		name = "USS Houston"
		type = cruiser
		model = 8
		seadefence = 2
		}

	division = {
		id = { type = 12333 id = 68 }
		name = "USS Boise"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 69 }
		name = "USS Marblehead"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 70 }
		name = "19th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 71 }
		name = "25th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 72 }
		name = "27th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 73 }
	name = "Asiatic Gunboat Squadron"
	location = 1804 #Manila
	leader = 60390 #Lee

	division = {
		id = { type = 12333 id = 74 }
		name = "USS Ashville"
		type = cruiser
		model = 0
		maxspeed = 12
		}

	division = {
		id = { type = 12333 id = 75 }
		name = "USS Tulsa"
		type = cruiser
		model = 0
		maxspeed = 12
		}

	division = {
		id = { type = 12333 id = 76 }
		name = "USS Sacramento"
		type = cruiser
		model = 0
		maxspeed = 12
		}
}

navalunit = {
	id = { type = 12333 id = 77 }
	name = "Caribbean Squadron"
	location = 267 #San Juan
	leader = 60349 #Barbey

	division = {
		id = { type = 12333 id = 78 }
		name = "USS Raliegh"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 79 }
		name = "USS Richmond"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 80 }
		name = "USS Trenton"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 81 }
		name = "28th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 82 }
		name = "29th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 83 }
		name = "30th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 84 }
	name = "Atlantic Fleet Carrier Group" # Tweaked Dr Rare Fix
	location = 181 #Norfolk
	leader = 60423 #Spruance

	division = {
		id = { type = 12333 id = 85 }
		name = "USS Yorktown"
		type = carrier
		model = 8
		}

	airunit = {
		id = { type = 12333 id = 8500 }
		name = "Yorktown Air Group"
		
		division = {
			id = { type = 12333 id = 8501 }
			name = "Yorktown Air Group I"
			type = Torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 8502 }
			name = "Yorktown Air Group II"
			type = Torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 8503 }
			name = "Yorktown Air Group III"
			type = Torpedo_plane
			model = 0
			}
                }

	division = {
		id = { type = 12333 id = 86 }
		name = "USS Ranger"
		type = carrier
		model = 4
		}

	airunit = {
		id = { type = 12333 id = 8600 }
		name = "Ranger Air Group"
		leader = 60440

		division = {
			id = { type = 12333 id = 8601 }
			name = "Ranger Air Group I"
			type = torpedo_plane
			model = 0
			}

		division = {
			id = { type = 12333 id = 8602 }
			name = "Ranger Air Group II"
			type = torpedo_plane
			model = 0
			}
		}

	division = {
		id = { type = 12333 id = 87 }
		name = "USS Minneapolis"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 88 }
		name = "USS Quincy"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 89 }
		name = "USS Honolulu"
		type = cruiser
		model = 7
		}

	division = {
		id = { type = 12333 id = 90 }
		name = "21st Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 91 }
		name = "22nd Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = { 
		id = { type = 12333 id = 92 }
		name = "25th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 93 }
	name = "West Pacific Squadron"
	location = 158 #San Francisco
	leader = 60367 #Fletcher

	division = {
		id = { type = 12333 id = 94 }
		name = "USS Vincennes"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 95 }
		name = "USS Wichita"
		type = cruiser
		model = 8
		}

	division = {
		id = { type = 12333 id = 96 }
		name = "USS Concord"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 97 }
		name = "USS Memphis"
		type = cruiser
		model = 3
		}

	division = {
		id = { type = 12333 id = 98 }
		name = "31st Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 99 }
		name = "32nd Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 100 }
		name = "33rd Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 101 }
		name = "34th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 102 }
	name = "Panama Squadron"
	location = 288 #Colon
	leader = 60389 #Leahy

	division = {
		id = { type = 12333 id = 103 }
		name = "USS Erie"
		type = cruiser
		model = 5
		}

	division = {
		id = { type = 12333 id = 104 }
		name = "USS Charleston"
		type = cruiser
		model = 5
		}

	division = {
		id = { type = 12333 id = 105 }
		name = "35th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 106 }
		name = "36th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = {
		id = { type = 12333 id = 107 }
		name = "39th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 108 }
	name = "Atlantic Fleet Reserve"
	location = 203 #Houston
	leader = 60354 #Callaghan

	division = {
		id = { type = 12333 id = 109 }
		name = "40th Destroyer Flotilla"
		type = destroyer
		model = 2
		strength = 2
		}

	division = {
		id = { type = 12333 id = 110 }
		name = "41st Destroyer Flotilla"
		type = destroyer
		model = 2
		strength = 2
		}
}

navalunit = {
	id = { type = 12333 id = 111 }
	name = "USCG Group New York"
	location = 124 #New York

	division = {
		id = { type = 12333 id = 112 }
		name = "USCG Alexander Hamilton"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 113 }
		name = "USCG Taney"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 114 }
		name = "USCG Chelan"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 115 }
		name = "USCG Tahoe"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 203 }
		name = "USCG Station Staten Island"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}
}

navalunit = {
	id = { type = 12333 id = 116 }
	name = "USCG Group Boston"
	location = 125 #Boston

	division = {
		id = { type = 12333 id = 117 }
		name = "USCG Spencer"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 118 }
		name = "USCG Ingham"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 119 }
		name = "USCG Champlain"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 204 }
		name = "USCG Station Gloucester"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}

	division = {
		id = { type = 12333 id = 205 }
		name = "USCG Station Cape Cod"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}
}

navalunit = {
	id = { type = 12333 id = 120 }
	name = "USCG Group New Orleans"
	location = 204 #New Orleans

	division = {
		id = { type = 12333 id = 121 }
		name = "USCG Bibb"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 122 }
		name = "USCG Ponchatrain"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 123 }
		name = "USCG Cayuga"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 206 }
		name = "USCG Station Grand Isle"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}

	division = {
		id = { type = 12333 id = 207 }
		name = "USCG Station Biloxi"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}
}

navalunit = {
	id = { type = 12333 id = 124 }
	name = "USCG Group Miami"
	location = 212 #Miami

	division = {
		id = { type = 12333 id = 125 }
		name = "USCG Campbell"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 126 }
		name = "USCG Mendota"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 127 }
		name = "USCG Sebago"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 208 }
		name = "USCG Station Key West"
		type = destroyer
		model = 1
		seaattack = 1
		maxspeed = 13
		}
}

navalunit = {
	id = { type = 12000 id = 128 }
	name = "USCG Group Seattle"
	location = 106 #Seattle

	division = { 
		id = { type = 12333 id = 129 }
		name = "USCG Northland"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 11
		}

	division = {
		id = { type = 12333 id = 130 }
		name = "USCG Shoshone"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}
}

navalunit = {
	id = { type = 12333 id = 131 }
	name = "USCG Group San Francisco"
	location = 158 #San Francisco

	division = {
		id = { type = 12333 id = 132 }
		name = "USCG Duane"
		type = cruiser
		model = 5
		seaattack = 1
		maxspeed = 19
		}

	division = {
		id = { type = 12333 id = 133 }
		name = "USCG Itasca"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}

	division = { 
		id = { type = 12333 id = 134 }
		name = "USCG Saranac"
		type = cruiser
		model = 0
		seaattack = 1
		maxspeed = 17
		}
}

navalunit = {
	id = { type = 12333 id = 135 }
	name = "Mine Support Force"
	location = 92 #Los Angeles
	leader = 60407 #Oldendorf

	division = {
		id = { type = 12333 id = 136 }
		name = "USS Oglala"
		type = cruiser
		model = 0
		seaattack = 1
		seadefence = 3
		maxspeed = 14
		}

	division = {
		id = { type = 12333 id = 137 }
		name = "USS Aroostook"
		type = cruiser
		model = 0
		seaattack = 1
		seadefence = 3
		maxspeed = 14
		}

	division = {
		id = { type = 12333 id = 138 }
		name = "37th Destroyer Flotilla"
		type = destroyer
		model = 2
		}

	division = { 
		id = { type = 12333 id = 139 }
		name = "38th Destroyer Flotilla"
		type = destroyer
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 140 }
	name = "1st Pacific Submarine Division"
	location = 22 #Honolulu
	leader = 60364 #English

	division = {
		id = { type = 12333 id = 141 }
		name = "1st Submarine Flotilla"
		type = submarine
		model = 6
		}

	division = {
		id = { type = 12333 id = 284 }
		name = "2nd Submarine Flotilla"
		type = submarine
		model = 6
		}

	division = {
		id = { type = 12333 id = 142 }
		name = "16th Submarine Flotilla"
		type = submarine
		model = 6
		}
}

navalunit = {
	id = { type = 12333 id = 143 }
	name = "2nd Pacific Submarine Division"
	location = 22 #Honolulu
	leader = 60362 #Durgin

	division = {
		id = { type = 12333 id = 144 }
		name = "3rd Submarine Flotilla"
		type = submarine
		model = 3
		}

	division = {
		id = { type = 12333 id = 145 }
		name = "6th Submarine Flotilla"
		type = submarine
		model = 3
		}

	division = {
		id = { type = 12333 id = 146 }
		name = "7th Submarine Flotilla"
		type = submarine
		model = 3
		}
}

navalunit = {
	id = { type = 12333 id = 147 }
	name = "3rd Pacific SUbmarine Division"
	location = 22 #Honolulu
	leader = 60372 #Glover

	division = {
		id = { type = 12333 id = 148 }
		name = "17th Submarine Flotilla"
		type = submarine
		model = 6
		}

	division = {
		id = { type = 12333 id = 149 }
		name = "18th Submarine Flotilla"
		type = submarine
		model = 6
		}
}

navalunit = {
	id = { type = 12333 id = 150 }
	name = "Asiatic Fleet Submarine Division"
	location = 1804
	leader = 60359 #Comstock

	division = {
		id = { type = 12333 id = 151 }
		name = "4th Submarine Flotilla"
		type = submarine
		model = 3
		}

	division = {
		id = { type = 12333 id = 152 }
		name = "5th Submarine Flotilla"
		type = submarine
		model = 3
		}

	division = {
		id = { type = 12333 id = 153 }
		name = "10th Submarine Flotilla"
		type = submarine
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 154 }
	name = "Canal Defense Submarine Division"
	location = 288 #Colon
	leader = 60366 #Fife

	division = {
		id = { type = 12333 id = 155 }
		name = "11th Submarine Flotilla"
		type = submarine
		model = 2
		}

	division = {
		id = { type = 12333 id = 156 }
		name = "12th Submarine Flotilla"
		type = submarine
		model = 2
		}

	division = {
		id = { type = 12333 id = 157 }
		name = "13th Submarine Flotilla"
		type = submarine
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 158 }
	name = "Atlantic Fleet Submarine Division"
	location = 181 #Norfolk
	leader = 60374 #Hall

	division = {
		id = { type = 12333 id = 159 }
		name = "8th Submarine Flotilla"
		type = submarine
		model = 3
		}

	division = {
		id = { type = 12333 id = 160 }
		name = "9th Submarine Flotilla"
		type = submarine
		model = 3
		}
}

navalunit = {
	id = { type = 12333 id = 161 }
	name = "Submarine Training Command"
	location = 125 #Boston
	leader = 60368 #Fuqua

	division = {
		id = { type = 12333 id = 162 }
		name = "14th Submarine Flotilla"
		type = submarine
		model = 2
		}

	division = {
		id = { type = 12333 id = 163 }
		name = "15th Submarine Flotilla"
		type = submarine
		model = 2
		}
}

navalunit = {
	id = { type = 12333 id = 164 }
	name = "Pacific Transport Division"
	location = 92 #Los Angeles
	leader = 60418 #Sherman

	division = {
		id = { type = 12333 id = 165 }
		name = "1st Transport Flotilla"
		type = transport
		model = 7
		}

	division = {
		id = { type = 12333 id = 166 }
		name = "2nd Transport Flotilla"
		type = transport
		model = 7
		}
}

navalunit = {
	id = { type = 12333 id = 167 }
	name = "Atlantic Transport Division"
	location = 125 #Boston
	leader = 60410 #Powell

	division = {
		id = { type = 12333 id = 168 }
		name = "3rd Transport Flotilla"
		type = transport
		model = 7
		}

	division = {
		id = { type = 12333 id = 169 }
		name = "4th Transport Flotilla"
		type = transport
		model = 7
		}
}

navalunit = {
	id = { type = 12333 id = 170 }
	name = "Matson Lines"
	location = 158 #San Francisco

	division = {
		id = { type = 12333 id = 171 }
		name = "SS Lurline"
		type = transport
		model = 1
		maxspeed = 22
		}

	division = {
		id = { type = 12333 id = 172 }
		name = "SS Malolo"
		type = transport
		model = 1
		maxspeed = 22
		}

	division = {
		id = { type = 12333 id = 173 }
		name = "SS Mariposa"
		type = transport
		model = 1
		maxspeed = 22
		}

	division = {
		id = { type = 12333 id = 174 }
		name = "SS Monterey"
		type = transport
		model = 1
		maxspeed = 22
		}
}

navalunit = {
	id = { type = 12333 id = 175 }
	name = "American President Lines"
	location = 158 #San Francisco

	division = {
		id = { type = 12333 id = 176 }
		name = "President Coolidge"
		type = transport
		model = 2
		maxspeed = 20
		}

	division = {
		id = { type = 12333 id = 177 }
		name = "President Hoover"
		type = transport
		model = 2
		maxspeed = 20
		}
}

navalunit = {
	id = { type = 12333 id = 178 }
	name = "United States Line"
	location = 124 #New York

	division = {
		id = { type = 12333 id = 179 }
		name = "SS Leviathan"
		type = transport
		model = 3
		maxspeed = 23
		}

	division = {
		id = { type = 12333 id = 180 }
		name = "SS America"
		type = transport
		model = 2
		maxspeed = 22
		}

	division = {
		id = { type = 12333 id = 181 }
		name = "SS Manhattan"
		type = transport
		model = 2
		maxspeed = 20
		}

	division = {
		id = { type = 12333 id = 182 }
		name = "SS Washington"
		type = transport
		model = 2
		maxspeed = 20
		}

	division = {
		id = { type = 12333 id = 183 }
		name = "SS Republic"
		type = transport
		model = 1
		maxspeed = 16
		}

	division = {
		id = { type = 12333 id = 184 }
		name = "SS President Roosevelt"
		type = transport
		model = 2
		maxspeed = 17
		}
}

navalunit = {
	id = { type = 12333 id = 185 }
	name = "American Republics Line"
	location = 204 #New Orleans

	division = {
		id = { type = 12333 id = 186 }
		name = "SS Argentina"
		type = transport
		model = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 187 }
		name = "SS Brazil"
		type = transport
		model = 1
		maxspeed = 17
		}

	division = {
		id = { type = 12333 id = 188 }
		name = "SS Uruguay"
		type = transport
		model = 1
		maxspeed = 17
		}
}

development = {
	id = { type = 12333 id = 189 }
	name = "USS North Carolina"
	type = battleship
	model = 8
	cost = 12
	date = { day = 9 month = april year = 1941 }
	}

development = {
	id = { type = 12333 id = 190 }
	name = "USS Washington"
	type = battleship
	model = 8
	cost = 12
	date = { day = 15 month = may year = 1941 }
	}

development = {
	id = { type = 12333 id = 191 }
	name = "USS South Dakota"
	type = battleship
	model = 8
	cost = 12
	date = { day = 20 month = march year = 1942 }
	}

development = {
	id = { type = 12333 id = 192 }
	name = "USS Massachusetts"
	type = battleship
	model = 8
	cost = 12
	date = { day = 15 month = may year = 1942 }
	}

development = {
	id = { type = 12333 id = 193 }
	name = "USS Wasp"
	type = carrier
	model = 4
	cost = 5
	date = { day = 25 month = april year = 1940 }
	}

development = {
	id = { type = 12333 id = 195 }
	name = "USS St. Louis"
	type = cruiser
	model = 7
	cost = 3
	date = { day = 1 month = december year = 1939 }
	}

development = {
	id = { type = 12333 id = 196 }
	name = "USS Helena"
	type = cruiser
	model = 7
	cost = 3
	date = { day = 15 month = december year = 1939 }
	}

development = {
	id = { type = 12333 id = 197 }
	name = "16th Destroyer Flotilla"
	type = destroyer
	model = 6
	cost = 1
	date = { day = 9 month = december year = 1939 }
	}

development = {
	id = { type = 12333 id = 198 }
	name = "17th Destroyer Flotilla"
	type = destroyer
	model = 6
	cost = 1
	date = { day = 22 month = january year = 1940 }
	}

development = {
	id = { type = 12333 id = 199 }
	name = "18th Destroyer Flotilla"
	type = destroyer
	model = 6
	cost = 1
	date = { day = 26 month = march year = 1940 }
	}

development = {
	id = { type = 12333 id = 200 }
	name = "19th Destroyer Flotilla"
	type = destroyer
	model = 6
	cost = 1
	date = { day = 31 month = may year = 1940 }
	}

development = {
	id = { type = 12333 id = 201 }
	name = "19th Submarine Flotilla"
	type = submarine
	model = 6
	cost = 1
	date = { day = 20 month = december year = 1939 }
	}

development = {
	id = { type = 12333 id = 202 }
	name = "20th Submarine Flotilla"
	type = submarine
	model = 6
	cost = 1
	date = { day = 27 month = march year = 1940 }
	}

####################


deactivate = {  8211 13114 11508 13504 11512 11507 11511 11513 11514 11515 11516 11517 11519 13417 4974 }

}
